<?php $__env->startSection('title', 'Data Jemaat'); ?>
<?php $__env->startSection('page-title', 'Data Jemaat'); ?>

<?php $__env->startSection('content'); ?>
<!-- Stats -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <div class="flex items-center justify-between">
        <div>
            <p class="text-slate-500 text-sm font-medium">Total Jemaat Aktif</p>
            <p class="text-3xl font-bold text-[#1e3a5f]"><?php echo e($totalJemaat); ?></p>
        </div>
        <div class="w-14 h-14 bg-gradient-to-br from-blue-100 to-blue-50 rounded-2xl flex items-center justify-center">
            <svg class="w-7 h-7 text-[#1e3a5f]" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
        </div>
    </div>
</div>

<!-- Daftar Jemaat -->
<div class="bg-white rounded-xl shadow-md p-6">
    <div class="flex items-center gap-2 mb-6">
        <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
        <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Jemaat</h2>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-gray-600 text-sm font-semibold">Nama</th>
                    <th class="px-4 py-3 text-left text-gray-600 text-sm font-semibold">Telepon</th>
                    <th class="px-4 py-3 text-left text-gray-600 text-sm font-semibold">Alamat</th>
                    <th class="px-4 py-3 text-left text-gray-600 text-sm font-semibold">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php $__empty_1 = true; $__currentLoopData = $jemaatAktif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-4">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 bg-[#1e3a5f] rounded-full flex items-center justify-center text-white font-bold">
                                <?php echo e(substr($j->nama, 0, 1)); ?>

                            </div>
                            <div>
                                <p class="font-semibold text-slate-800"><?php echo e($j->nama); ?></p>
                                <p class="text-xs text-slate-500"><?php echo e($j->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'); ?></p>
                            </div>
                        </div>
                    </td>
                    <td class="px-4 py-4 text-slate-600"><?php echo e($j->telepon ?? '-'); ?></td>
                    <td class="px-4 py-4 text-slate-600 text-sm"><?php echo e(Str::limit($j->alamat, 40) ?? '-'); ?></td>
                    <td class="px-4 py-4">
                        <a href="<?php echo e(route('pendeta.jemaat.show', $j->id)); ?>" class="inline-flex items-center gap-2 px-4 py-2 bg-[#1e3a5f] text-white rounded-lg text-sm font-semibold hover:bg-[#4a3121] transition">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                            Lihat
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="4" class="px-4 py-8 text-center text-slate-500">Belum ada data jemaat</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <?php echo e($jemaatAktif->links('components.pagination')); ?>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pendeta', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/pendeta/jemaat/index.blade.php ENDPATH**/ ?>