<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Sistem Informasi Gereja Jemaat Buntu Ambaang">
    <title><?php echo $__env->yieldContent('title', 'Gereja Jemaat Buntu Ambaang'); ?></title>
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
</head>
<body class="min-h-screen flex flex-col bg-slate-50">
    
    <!-- Navigation -->
    <header class="fixed top-0 left-0 right-0 z-50 transition-all duration-300" id="navbar">
        <div class="glass shadow-material-1">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-center justify-between h-20">
                    
                    <!-- Logo -->
                    <a href="<?php echo e(route('beranda')); ?>" class="flex items-center gap-3 group">
                        <div class="w-12 h-12 bg-gradient-primary rounded-2xl flex items-center justify-center shadow-material-1 group-hover:shadow-material-2 transition-all duration-300 group-hover:scale-105">
                            <svg class="w-7 h-7 text-white" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 12h3v8h6v-6h2v6h6v-8h3L12 2z"/>
                            </svg>
                        </div>
                        <div class="hidden sm:block">
                            <h1 class="text-lg font-bold text-primary leading-tight">Gereja Jemaat</h1>
                            <p class="text-sm font-medium text-secondary">Buntu Ambaang</p>
                        </div>
                    </a>
                    
                    <!-- Desktop Navigation -->
                    <nav class="hidden lg:flex items-center gap-1">
                        <a href="<?php echo e(route('beranda')); ?>" class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200">Beranda</a>
                        <a href="<?php echo e(route('jadwal-ibadah')); ?>" class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200">Jadwal Ibadah</a>
                        <a href="<?php echo e(route('oig.index')); ?>" class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200">OIG</a>
                        <a href="<?php echo e(route('kegiatan.index')); ?>" class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200">Kegiatan</a>
                        <a href="<?php echo e(route('berita.index')); ?>" class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200">Berita</a>
                        <a href="<?php echo e(route('kalender')); ?>" class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200">Kalender</a>
                        
                        <!-- Dropdown More -->
                        <div class="relative group">
                            <button class="px-4 py-2.5 text-gray-700 font-medium rounded-xl hover:bg-primary/10 hover:text-primary transition-all duration-200 flex items-center gap-1">
                                Lainnya
                                <svg class="w-4 h-4 transition-transform group-hover:rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                            <div class="absolute top-full right-0 mt-2 w-48 bg-white rounded-2xl shadow-material-3 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-200 overflow-hidden">
                                <a href="<?php echo e(route('profil')); ?>" class="block px-4 py-3 text-gray-700 hover:bg-slate-50 hover:text-primary transition-colors">Profil Gereja</a>
                                <a href="<?php echo e(route('formulir.index')); ?>" class="block px-4 py-3 text-gray-700 hover:bg-slate-50 hover:text-primary transition-colors">Formulir</a>
                                <a href="<?php echo e(route('donasi')); ?>" class="block px-4 py-3 text-gray-700 hover:bg-slate-50 hover:text-primary transition-colors">Donasi</a>
                                <a href="<?php echo e(route('laporan-keuangan')); ?>" class="block px-4 py-3 text-gray-700 hover:bg-slate-50 hover:text-primary transition-colors">Laporan Keuangan</a>
                            </div>
                        </div>
                        
                        <a href="<?php echo e(route('kontak')); ?>" class="ml-2 px-6 py-2.5 bg-secondary text-primary font-semibold rounded-xl hover:bg-secondary-light shadow-material-1 hover:shadow-material-2 transition-all duration-200">
                            Hubungi Kami
                        </a>
                    </nav>
                    
                    <!-- Mobile Menu Button -->
                    <button id="mobile-menu-btn" class="lg:hidden p-3 rounded-xl hover:bg-slate-100 transition-colors">
                        <svg class="w-6 h-6 text-gray-700" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Navigation -->
        <nav id="mobile-menu" class="lg:hidden hidden bg-white border-t border-slate-100 shadow-material-2">
            <div class="max-w-7xl mx-auto px-4 py-4 space-y-1">
                <a href="<?php echo e(route('beranda')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/></svg>
                    Beranda
                </a>
                <a href="<?php echo e(route('jadwal-ibadah')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                    Jadwal Ibadah
                </a>
                <a href="<?php echo e(route('oig.index')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                    OIG
                </a>
                <a href="<?php echo e(route('kegiatan.index')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/></svg>
                    Kegiatan
                </a>
                <a href="<?php echo e(route('berita.index')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/></svg>
                    Berita
                </a>
                <a href="<?php echo e(route('kalender')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                    Kalender
                </a>
                <a href="<?php echo e(route('formulir.index')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/></svg>
                    Formulir
                </a>
                <a href="<?php echo e(route('donasi')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                    Donasi
                </a>
                <a href="<?php echo e(route('laporan-keuangan')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/></svg>
                    Laporan Keuangan
                </a>
                <a href="<?php echo e(route('profil')); ?>" class="flex items-center gap-3 px-4 py-3 text-gray-700 font-medium rounded-xl hover:bg-slate-50 transition-colors">
                    <svg class="w-5 h-5 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/></svg>
                    Profil Gereja
                </a>
                <div class="pt-2">
                    <a href="<?php echo e(route('kontak')); ?>" class="flex items-center justify-center gap-2 px-4 py-3 bg-secondary text-primary font-semibold rounded-xl shadow-material-1">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                        Hubungi Kami
                    </a>
                </div>
            </div>
        </nav>
    </header>

    <!-- Spacer for fixed header -->
    <div class="h-20"></div>

    <!-- Main Content -->
    <main class="flex-grow">
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer -->
    <footer class="bg-primary text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Main Footer -->
            <div class="py-16 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-12">
                <!-- Brand -->
                <div class="lg:col-span-1">
                    <div class="flex items-center gap-3 mb-6">
                        <div class="w-12 h-12 bg-secondary rounded-2xl flex items-center justify-center">
                            <svg class="w-7 h-7 text-primary" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 12h3v8h6v-6h2v6h6v-8h3L12 2z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="font-bold text-white">Gereja Jemaat</h3>
                            <p class="text-sm text-secondary">Buntu Ambaang</p>
                        </div>
                    </div>
                    <p class="text-slate-300 leading-relaxed">
                        Melayani jemaat dengan kasih Kristus, menjangkau jiwa-jiwa yang membutuhkan pelayanan rohani.
                    </p>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h4 class="text-secondary font-semibold mb-6">Menu Cepat</h4>
                    <ul class="space-y-3">
                        <li><a href="<?php echo e(route('jadwal-ibadah')); ?>" class="text-slate-300 hover:text-white transition-colors">Jadwal Ibadah</a></li>
                        <li><a href="<?php echo e(route('kegiatan.index')); ?>" class="text-slate-300 hover:text-white transition-colors">Kegiatan</a></li>
                        <li><a href="<?php echo e(route('formulir.doa')); ?>" class="text-slate-300 hover:text-white transition-colors">Permohonan Doa</a></li>
                        <li><a href="<?php echo e(route('donasi')); ?>" class="text-slate-300 hover:text-white transition-colors">Donasi</a></li>
                    </ul>
                </div>
                
                <!-- Contact -->
                <div>
                    <h4 class="text-secondary font-semibold mb-6">Kontak</h4>
                    <ul class="space-y-3 text-slate-300">
                        <li class="flex items-start gap-3">
                            <svg class="w-5 h-5 mt-0.5 text-secondary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                            <span>Buntu Ambaang, Sulawesi Selatan</span>
                        </li>
                        <li class="flex items-center gap-3">
                            <svg class="w-5 h-5 text-secondary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            <span>info@gerejabuntuambaang.org</span>
                        </li>
                        <li class="flex items-center gap-3">
                            <svg class="w-5 h-5 text-secondary flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                            <span>(0423) xxx-xxxx</span>
                        </li>
                    </ul>
                </div>
                
                <!-- Schedule -->
                <div>
                    <h4 class="text-secondary font-semibold mb-6">Jadwal Ibadah</h4>
                    <div class="space-y-4">
                        <div class="bg-white/10 rounded-xl p-4">
                            <p class="font-semibold text-white">Minggu Pagi</p>
                            <p class="text-slate-300">09:00 WIB</p>
                        </div>
                        <div class="bg-white/10 rounded-xl p-4">
                            <p class="font-semibold text-white">Persekutuan Doa</p>
                            <p class="text-slate-300">Rabu, 18:00 WIB</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Bottom Footer -->
            <div class="border-t border-white/10 py-6">
                <div class="flex flex-col md:flex-row items-center justify-between gap-4">
                    <p class="text-slate-400 text-sm">
                        &copy; <?php echo e(date('Y')); ?> Gereja Jemaat Buntu Ambaang. All rights reserved.
                    </p>
                    <div class="flex items-center gap-4">
                        <a href="#" class="w-10 h-10 bg-white/10 rounded-xl flex items-center justify-center hover:bg-secondary hover:text-primary transition-all duration-200">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                        </a>
                        <a href="#" class="w-10 h-10 bg-white/10 rounded-xl flex items-center justify-center hover:bg-secondary hover:text-primary transition-all duration-200">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/></svg>
                        </a>
                        <a href="#" class="w-10 h-10 bg-white/10 rounded-xl flex items-center justify-center hover:bg-secondary hover:text-primary transition-all duration-200">
                            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/></svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <script>
        // Mobile menu toggle
        document.getElementById('mobile-menu-btn').addEventListener('click', function() {
            document.getElementById('mobile-menu').classList.toggle('hidden');
        });
        
        // Navbar scroll effect
        window.addEventListener('scroll', function() {
            const navbar = document.getElementById('navbar');
            if (window.scrollY > 50) {
                navbar.classList.add('shadow-material-2');
            } else {
                navbar.classList.remove('shadow-material-2');
            }
        });
    </script>
</body>
</html>
<?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/layouts/public.blade.php ENDPATH**/ ?>