<?php $__env->startSection('title', isset($jadwal) ? 'Edit Jadwal' : 'Tambah Jadwal'); ?>
<?php $__env->startSection('page-title', isset($jadwal) ? 'Edit Jadwal Ibadah' : 'Tambah Jadwal Ibadah'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl">
    <div class="bg-white rounded-xl shadow-md p-6">
        <form action="<?php echo e(isset($jadwal) ? route('admin.jadwal.update', $jadwal['id']) : route('admin.jadwal.store')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php if(isset($jadwal)): ?>
            <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div>
                <label class="block text-gray-700 font-semibold mb-2">Nama Ibadah *</label>
                <input type="text" name="nama" value="<?php echo e($jadwal['nama'] ?? old('nama')); ?>" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">Hari *</label>
                    <select name="hari" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
                        <option value="">Pilih Hari</option>
                        <?php $__currentLoopData = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hari): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($hari); ?>" <?php echo e((isset($jadwal) && $jadwal['hari'] == $hari) ? 'selected' : ''); ?>><?php echo e($hari); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div>
                    <label class="block text-gray-700 font-semibold mb-2">Waktu *</label>
                    <input type="time" name="waktu" value="<?php echo e($jadwal['waktu'] ?? old('waktu')); ?>" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
                </div>
            </div>

            <div>
                <label class="block text-gray-700 font-semibold mb-2">Tempat *</label>
                <input type="text" name="tempat" value="<?php echo e($jadwal['tempat'] ?? old('tempat')); ?>" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
            </div>

            <div>
                <label class="block text-gray-700 font-semibold mb-2">Pelayan Firman *</label>
                <input type="text" name="pelayan" value="<?php echo e($jadwal['pelayan'] ?? old('pelayan')); ?>" required class="w-full px-4 py-3 border-2 border-gray-300 rounded-lg focus:border-gereja-biru focus:outline-none">
            </div>

            <div class="flex items-center space-x-4">
                <button type="submit" class="px-8 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
                    <?php echo e(isset($jadwal) ? 'Update' : 'Simpan'); ?>

                </button>
                <a href="<?php echo e(route('admin.jadwal.index')); ?>" class="px-8 py-3 bg-gray-300 text-gray-700 rounded-lg font-bold hover:bg-gray-400 transition">
                    Batal
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/jadwal/form.blade.php ENDPATH**/ ?>