<?php $__env->startSection('title', 'Konseling Rohani - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Material Design -->
<section class="relative py-12 md:py-16 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-48 h-48 rounded-full opacity-10" style="background: #d4af37; filter: blur(50px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <a href="<?php echo e(route('formulir.index')); ?>" class="inline-flex items-center mb-4 transition-colors" style="color: #d4af37;">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/></svg>
            Kembali
        </a>
        <h1 class="text-3xl md:text-4xl font-bold" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Formulir Konseling Rohani
        </h1>
    </div>
</section>

<!-- Form -->
<section class="py-12 bg-slate-50">
    <div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-material-2 p-8">
            <div class="rounded-xl p-4 mb-8" style="background: rgba(212,175,55,0.15); border: 1px solid #d4af37;">
                <p class="font-semibold" style="color: #1e3a5f;">Konseling bersifat rahasia dan ditangani langsung oleh pendeta. Kami siap mendengarkan dan mendampingi Anda.</p>
            </div>
            
            <form action="<?php echo e(route('formulir.konseling.submit')); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap *</label>
                    <input type="text" name="nama" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Nomor Telepon *</label>
                        <input type="tel" name="telepon" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                    </div>
                    <div>
                        <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Jenis Kelamin</label>
                        <select name="jenis_kelamin" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                            <option value="">Pilih</option>
                            <option value="laki-laki">Laki-laki</option>
                            <option value="perempuan">Perempuan</option>
                        </select>
                    </div>
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Kategori Konseling *</label>
                    <select name="kategori" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                        <option value="">Pilih kategori</option>
                        <option value="pernikahan">Pernikahan / Pranikah</option>
                        <option value="keluarga">Masalah Keluarga</option>
                        <option value="pribadi">Masalah Pribadi</option>
                        <option value="rohani">Pertumbuhan Rohani</option>
                        <option value="kesehatan_mental">Kesehatan Mental</option>
                        <option value="lainnya">Lainnya</option>
                    </select>
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Metode Konseling yang Diinginkan *</label>
                    <div class="space-y-3">
                        <label class="flex items-center p-4 bg-slate-50 rounded-xl cursor-pointer hover:bg-slate-100 transition-colors">
                            <input type="radio" name="metode" value="tatap_muka" class="w-5 h-5 mr-4">
                            <span class="text-base">Tatap Muka di Gereja</span>
                        </label>
                        <label class="flex items-center p-4 bg-slate-50 rounded-xl cursor-pointer hover:bg-slate-100 transition-colors">
                            <input type="radio" name="metode" value="online" class="w-5 h-5 mr-4">
                            <span class="text-base">Online (Zoom / Google Meet)</span>
                        </label>
                        <label class="flex items-center p-4 bg-slate-50 rounded-xl cursor-pointer hover:bg-slate-100 transition-colors">
                            <input type="radio" name="metode" value="telepon" class="w-5 h-5 mr-4">
                            <span class="text-base">Melalui Telepon</span>
                        </label>
                    </div>
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Waktu yang Diinginkan</label>
                    <input type="datetime-local" name="waktu" class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors">
                </div>
                
                <div>
                    <label class="block text-base font-semibold mb-2" style="color: #1e3a5f;">Gambaran Singkat Permasalahan *</label>
                    <textarea name="gambaran" rows="5" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl text-base focus:outline-none transition-colors" placeholder="Ceritakan secara singkat apa yang ingin Anda konsultasikan..."></textarea>
                </div>
                
                <button type="submit" class="w-full px-8 py-4 rounded-xl font-bold text-lg transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    Ajukan Konseling
                </button>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/formulir/konseling.blade.php ENDPATH**/ ?>