<?php $__env->startSection('title', 'Pesan Masuk'); ?>
<?php $__env->startSection('page-title', 'Pesan Masuk'); ?>

<?php $__env->startSection('content'); ?>
<!-- Stats Card -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <div class="flex items-center justify-between">
        <div>
            <p class="text-slate-500 text-sm font-medium">Pesan Belum Dibaca</p>
            <p class="text-3xl font-bold text-purple-600"><?php echo e($totalBelumDibaca); ?></p>
        </div>
        <div class="w-14 h-14 bg-gradient-to-br from-purple-100 to-purple-50 rounded-2xl flex items-center justify-center">
            <svg class="w-7 h-7 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
        </div>
    </div>
</div>

<!-- Daftar Pesan -->
<div class="bg-white rounded-xl shadow-md p-6">
    <div class="flex items-center gap-2 mb-6">
        <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
        <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Pesan</h2>
        <span class="text-sm text-slate-500 ml-2">(Read-Only)</span>
    </div>

    <div class="space-y-4">
        <?php $__empty_1 = true; $__currentLoopData = $pesanList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pesan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="bg-slate-50 rounded-xl p-5 hover:shadow-md transition-all duration-300 border border-slate-100 <?php echo e(!$pesan->dibaca ? 'border-l-4 border-l-purple-500' : ''); ?>">
            <div class="flex flex-col md:flex-row md:items-start md:justify-between gap-4">
                <div class="flex items-start gap-4 flex-grow">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-br <?php echo e(!$pesan->dibaca ? 'from-purple-100 to-purple-50' : 'from-slate-200 to-slate-100'); ?> flex items-center justify-center flex-shrink-0">
                        <svg class="w-6 h-6 <?php echo e(!$pesan->dibaca ? 'text-purple-600' : 'text-slate-500'); ?>" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    </div>
                    <div class="flex-grow min-w-0">
                        <div class="flex items-center gap-2 mb-1">
                            <h3 class="font-bold text-[#1e3a5f] text-lg truncate"><?php echo e($pesan->nama); ?></h3>
                            <?php if(!$pesan->dibaca): ?>
                            <span class="px-2 py-0.5 bg-purple-500 text-white rounded-full text-xs font-semibold">Baru</span>
                            <?php endif; ?>
                        </div>
                        <p class="text-sm text-slate-500 mb-2"><?php echo e($pesan->email); ?></p>
                        <p class="font-semibold text-slate-700 text-[15px] mb-1"><?php echo e($pesan->subjek); ?></p>
                        <p class="text-slate-600 text-sm line-clamp-2"><?php echo e(Str::limit($pesan->pesan, 120)); ?></p>
                        <p class="text-xs text-slate-400 mt-2"><?php echo e($pesan->created_at->format('d M Y, H:i')); ?></p>
                    </div>
                </div>
                <div>
                    <a href="<?php echo e(route('pendeta.pesan.show', $pesan->id)); ?>" class="inline-flex items-center gap-2 px-4 py-2 bg-[#1e3a5f] text-white rounded-lg text-sm font-semibold hover:bg-[#4a3121] transition">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                        Lihat
                    </a>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="text-center py-12 text-slate-500">
            <svg class="w-16 h-16 mx-auto mb-4 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
            <p>Belum ada pesan masuk</p>
        </div>
        <?php endif; ?>
    </div>
    
    <?php echo e($pesanList->links('components.pagination')); ?>

</div>

<style>
.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.pendeta', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/pendeta/pesan/index.blade.php ENDPATH**/ ?>