<?php $__env->startSection('title', 'Jadwal Ibadah - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Material Design -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Ibadah & Persekutuan
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Jadwal Ibadah
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Bergabunglah bersama kami dalam ibadah dan persekutuan
        </p>
    </div>
</section>

<!-- Jadwal Ibadah Minggu -->
<section class="py-12 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold mb-8" style="color: #1e3a5f;">Ibadah Mingguan</h2>
        <div class="overflow-x-auto rounded-2xl shadow-material-2">
            <table class="w-full bg-white">
                <thead style="background: #1e3a5f;">
                    <tr>
                        <th class="px-6 py-4 text-left text-base font-semibold" style="color: #ffffff;">Ibadah</th>
                        <th class="px-6 py-4 text-left text-base font-semibold" style="color: #ffffff;">Hari</th>
                        <th class="px-6 py-4 text-left text-base font-semibold" style="color: #ffffff;">Waktu</th>
                        <th class="px-6 py-4 text-left text-base font-semibold" style="color: #ffffff;">Tempat</th>
                        <th class="px-6 py-4 text-left text-base font-semibold" style="color: #ffffff;">Pelayan Firman</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__currentLoopData = $jadwalMingguan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jadwal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-slate-50 transition-colors">
                        <td class="px-6 py-5 font-semibold" style="color: #1e3a5f;"><?php echo e($jadwal['nama']); ?></td>
                        <td class="px-6 py-5 text-gray-600"><?php echo e($jadwal['hari']); ?></td>
                        <td class="px-6 py-5">
                            <span class="px-3 py-1.5 rounded-full text-sm font-bold" style="background: #d4af37; color: #1e3a5f;"><?php echo e($jadwal['waktu']); ?></span>
                        </td>
                        <td class="px-6 py-5 text-gray-600"><?php echo e($jadwal['tempat']); ?></td>
                        <td class="px-6 py-5 text-gray-600"><?php echo e($jadwal['pelayan']); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</section>

<!-- Jadwal Ibadah Khusus -->
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold mb-8" style="color: #1e3a5f;">Ibadah Khusus</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <?php $__currentLoopData = $jadwalKhusus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $jadwal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300 hover:-translate-y-1">
                <div class="px-6 py-3" style="background: #d4af37;">
                    <span class="font-bold" style="color: #1e3a5f;"><?php echo e($jadwal['kategori']); ?></span>
                </div>
                <div class="p-6">
                    <h3 class="text-xl font-bold mb-4" style="color: #1e3a5f;"><?php echo e($jadwal['nama']); ?></h3>
                    <div class="space-y-3 text-gray-600">
                        <p class="flex items-center">
                            <svg class="w-5 h-5 mr-3" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                            <?php echo e($jadwal['tanggal']); ?>

                        </p>
                        <p class="flex items-center">
                            <svg class="w-5 h-5 mr-3" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                            <?php echo e($jadwal['waktu']); ?>

                        </p>
                        <p class="flex items-center">
                            <svg class="w-5 h-5 mr-3" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                            <?php echo e($jadwal['tempat']); ?>

                        </p>
                        <p class="flex items-center">
                            <svg class="w-5 h-5 mr-3" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                            <?php echo e($jadwal['pelayan']); ?>

                        </p>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/jadwal-ibadah.blade.php ENDPATH**/ ?>