<?php $__env->startSection('title', isset($donasi) ? 'Edit Donasi' : 'Tambah Donasi'); ?>
<?php $__env->startSection('page-title', isset($donasi) ? 'Edit Donasi' : 'Tambah Donasi'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl">
    <!-- Back Button -->
    <a href="<?php echo e(route('admin.donasi.index')); ?>" class="inline-flex items-center gap-2 text-slate-600 hover:text-[#1e3a5f] font-medium mb-5 transition-colors duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
        </svg>
        Kembali ke Daftar Donasi
    </a>

    <div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
        <div class="flex items-center gap-3 mb-6">
            <div class="w-12 h-12 rounded-xl bg-gradient-to-br from-emerald-100 to-emerald-50 flex items-center justify-center">
                <svg class="w-6 h-6 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
            </div>
            <div>
                <h2 class="text-xl font-bold text-[#1e3a5f]"><?php echo e(isset($donasi) ? 'Edit Data Donasi' : 'Input Donasi Baru'); ?></h2>
                <p class="text-sm text-slate-500"><?php echo e(isset($donasi) ? 'Perbarui informasi donasi' : 'Lengkapi data donasi di bawah ini'); ?></p>
            </div>
        </div>

        <form action="<?php echo e(isset($donasi) ? route('admin.donasi.update', $donasi->id) : route('admin.donasi.store')); ?>" method="POST" class="space-y-5">
            <?php echo csrf_field(); ?>
            <?php if(isset($donasi)): ?>
            <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Nama Donatur *</label>
                    <input type="text" name="nama" value="<?php echo e($donasi->nama ?? old('nama')); ?>" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="Nama lengkap donatur">
                </div>
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Nomor Telepon *</label>
                    <input type="tel" name="telepon" value="<?php echo e($donasi->telepon ?? old('telepon')); ?>" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                        placeholder="08xxxxxxxxxx">
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Jumlah Donasi *</label>
                    <div class="relative">
                        <span class="absolute left-4 top-1/2 -translate-y-1/2 text-slate-400 font-medium">Rp</span>
                        <input type="number" name="jumlah" value="<?php echo e($donasi->jumlah ?? old('jumlah')); ?>" required
                            class="w-full pl-12 pr-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200"
                            placeholder="0">
                    </div>
                </div>
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tujuan Donasi *</label>
                    <select name="tujuan" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                        <option value="">Pilih Tujuan</option>
                        <option value="persembahan" <?php echo e((isset($donasi) && $donasi->tujuan == 'persembahan') ? 'selected' : ''); ?>>Persembahan</option>
                        <option value="diakonia" <?php echo e((isset($donasi) && $donasi->tujuan == 'diakonia') ? 'selected' : ''); ?>>Diakonia</option>
                        <option value="pembangunan" <?php echo e((isset($donasi) && $donasi->tujuan == 'pembangunan') ? 'selected' : ''); ?>>Pembangunan</option>
                    </select>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Tanggal Transfer *</label>
                    <input type="date" name="tanggal_transfer" value="<?php echo e(isset($donasi) ? $donasi->tanggal_transfer->format('Y-m-d') : old('tanggal_transfer')); ?>" required
                        class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                </div>
                <div>
                    <label class="block text-slate-700 font-semibold text-[15px] mb-2">Status *</label>
                    <select name="status" required class="w-full px-4 py-3.5 bg-slate-50 border-2 border-slate-200 rounded-xl text-[15px] focus:border-[#1e3a5f] focus:bg-white focus:outline-none transition-all duration-200">
                        <option value="pending" <?php echo e((isset($donasi) && $donasi->status == 'pending') ? 'selected' : ''); ?>>Pending</option>
                        <option value="dikonfirmasi" <?php echo e((isset($donasi) && $donasi->status == 'dikonfirmasi') ? 'selected' : ''); ?>>Dikonfirmasi</option>
                        <option value="ditolak" <?php echo e((isset($donasi) && $donasi->status == 'ditolak') ? 'selected' : ''); ?>>Ditolak</option>
                    </select>
                </div>
            </div>

            <div class="flex items-center gap-4 pt-5 border-t border-slate-200 mt-6">
                <button type="submit" class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                    </svg>
                    <?php echo e(isset($donasi) ? 'Update Donasi' : 'Simpan Donasi'); ?>

                </button>
                <a href="<?php echo e(route('admin.donasi.index')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-slate-100 text-slate-700 rounded-xl font-semibold text-[15px] hover:bg-slate-200 transition-all duration-200">
                    Batal
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/donasi/form.blade.php ENDPATH**/ ?>