<?php $__env->startSection('title', $oig['nama'] . ' - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Header -->
    <section class="bg-gereja-biru text-white py-12">
        <div class="container mx-auto px-4">
            <a href="<?php echo e(route('oig.index')); ?>" class="inline-flex items-center text-gereja-emas hover:text-yellow-400 mb-4">
                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
                </svg>
                Kembali ke Daftar OIG
            </a>
            <h1 class="text-3xl md:text-4xl font-bold"><?php echo e($oig['nama']); ?></h1>
        </div>
    </section>

    <!-- Detail OIG -->
    <section class="py-12 bg-white">
        <div class="container mx-auto px-4">
            <div class="max-w-4xl mx-auto">
                <!-- Deskripsi -->
                <div class="bg-gray-50 rounded-xl p-8 mb-8">
                    <h2 class="text-2xl font-bold text-gereja-biru mb-4">Tentang <?php echo e($oig['nama']); ?></h2>
                    <p class="text-gray-600 text-lg leading-relaxed"><?php echo e($oig['deskripsi']); ?></p>
                </div>

                <!-- Struktur Pengurus -->
                <div class="bg-gray-50 rounded-xl p-8 mb-8">
                    <h2 class="text-2xl font-bold text-gereja-biru mb-6">Struktur Pengurus</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <?php $__currentLoopData = $oig['pengurus']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-white rounded-lg p-4 flex items-center">
                                <div class="w-12 h-12 bg-gereja-biru rounded-full flex items-center justify-center mr-4">
                                    <span class="text-white font-bold"><?php echo e(substr($p['nama'] ?? '', 0, 1)); ?></span>
                                </div>
                                <div>
                                    <p class="font-bold text-gereja-biru"><?php echo e($p['nama'] ?? '-'); ?></p>
                                    <p class="text-sm text-gray-500"><?php echo e($p['jabatan'] ?? '-'); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Jadwal Pertemuan -->
                <div class="bg-gereja-emas rounded-xl p-8">
                    <h2 class="text-2xl font-bold text-gereja-biru mb-4">Jadwal Pertemuan</h2>
                    <div class="flex items-center text-gereja-biru">
                        <svg class="w-8 h-8 mr-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z" />
                        </svg>
                        <p class="text-xl font-semibold"><?php echo e($oig['jadwal']); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/oig/show.blade.php ENDPATH**/ ?>