<?php $__env->startSection('title', isset($user) ? 'Edit Pengguna' : 'Tambah Pengguna'); ?>
<?php $__env->startSection('page-title', isset($user) ? 'Edit Pengguna' : 'Tambah Pengguna'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-2xl">
    <div class="bg-white rounded-xl shadow-md p-6">
        <form action="<?php echo e(isset($user) ? route('admin.user.update', $user->id) : route('admin.user.store')); ?>" method="POST" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php if(isset($user)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama *</label>
                <input type="text" name="name" value="<?php echo e($user->name ?? old('name')); ?>" required 
                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                    placeholder="Nama lengkap">
            </div>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Email *</label>
                <input type="email" name="email" value="<?php echo e($user->email ?? old('email')); ?>" required 
                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                    placeholder="email@gereja.org">
            </div>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Password <?php echo e(isset($user) ? '(kosongkan jika tidak diubah)' : '*'); ?></label>
                <input type="password" name="password" <?php echo e(isset($user) ? '' : 'required'); ?>

                    class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                    placeholder="Minimal 6 karakter">
            </div>

            <div>
                <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Role *</label>
                <select name="role" required class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    <option value="">Pilih Role</option>
                    <?php $__currentLoopData = \App\Models\User::getRoles(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($value); ?>" <?php echo e((isset($user) && $user->role == $value) ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <p class="text-xs text-gray-500 mt-1">Admin: Akses penuh | Pendeta: Akses terbatas (read-only)</p>
            </div>

            <div>
                <label class="flex items-center">
                    <input type="checkbox" name="is_active" value="1" <?php echo e((isset($user) && $user->is_active) ? 'checked' : (!isset($user) ? 'checked' : '')); ?> 
                        class="w-5 h-5 mr-3 rounded border-gray-300">
                    <span class="text-sm font-semibold" style="color: #1e3a5f;">Akun Aktif</span>
                </label>
            </div>

            <div class="flex items-center gap-4 pt-4">
                <button type="submit" class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    <?php echo e(isset($user) ? 'Update Pengguna' : 'Simpan Pengguna'); ?>

                </button>
                <a href="<?php echo e(route('admin.user.index')); ?>" class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                    Batal
                </a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/user/form.blade.php ENDPATH**/ ?>