<?php $__env->startSection('title', 'Donasi - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Material Design -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <!-- Decorative elements -->
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Persembahan & Kasih
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Donasi & Persembahan
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            Bersama membangun rumah Tuhan
        </p>
    </div>
</section>

<!-- Info Rekening -->
<section class="py-12 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-4xl mx-auto">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Rekening Bank -->
                <div class="bg-slate-50 rounded-2xl p-8">
                    <h2 class="text-2xl font-bold mb-6" style="color: #1e3a5f;">Transfer Bank</h2>
                    <div class="space-y-6">
                        <?php $__empty_1 = true; $__currentLoopData = $rekeningList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $rekening): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="bg-white rounded-xl p-6 border-2 <?php echo e($rekening->is_primary ? '' : 'border-gray-200'); ?>" style="<?php echo e($rekening->is_primary ? 'border-color: #1e3a5f;' : ''); ?>">
                            <p class="text-gray-500 mb-1"><?php echo e($rekening->nama_bank); ?></p>
                            <p class="text-2xl font-bold mb-2" style="color: #1e3a5f;"><?php echo e($rekening->nomor_rekening); ?></p>
                            <p class="text-gray-600">a.n. <?php echo e($rekening->atas_nama); ?></p>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="bg-white rounded-xl p-6 border-2 border-gray-200 text-center">
                            <p class="text-gray-500">Belum ada rekening bank tersedia</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- QR Code -->
                <div class="bg-slate-50 rounded-2xl p-8 text-center">
                    <h2 class="text-2xl font-bold mb-6" style="color: #1e3a5f;">Scan QR Code</h2>
                    <div class="bg-white rounded-xl p-6 inline-block mb-4 shadow-material-1">
                        <div class="w-48 h-48 bg-gray-100 rounded-lg flex items-center justify-center">
                            <svg class="w-24 h-24 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v1m6 11h2m-6 0h-2v4m0-11v3m0 0h.01M12 12h4.01M16 20h2M4 12h4m12 0h.01M5 8h2a1 1 0 001-1V5a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1zm12 0h2a1 1 0 001-1V5a1 1 0 00-1-1h-2a1 1 0 00-1 1v2a1 1 0 001 1zM5 20h2a1 1 0 001-1v-2a1 1 0 00-1-1H5a1 1 0 00-1 1v2a1 1 0 001 1z"/>
                            </svg>
                        </div>
                    </div>
                    <p class="text-gray-600">QRIS - Semua Aplikasi E-Wallet</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Tujuan Donasi -->
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold mb-8 text-center" style="color: #1e3a5f;">Tujuan Donasi</h2>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 max-w-4xl mx-auto">
            <div class="bg-white rounded-2xl p-6 text-center shadow-material-1 hover:shadow-material-2 transition-all">
                <div class="w-16 h-16 mx-auto mb-4 rounded-full flex items-center justify-center" style="background: #d4af37;">
                    <svg class="w-8 h-8" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
                </div>
                <h3 class="text-xl font-bold mb-2" style="color: #1e3a5f;">Persembahan</h3>
                <p class="text-gray-600">Persembahan rutin untuk operasional gereja</p>
            </div>
            <div class="bg-white rounded-2xl p-6 text-center shadow-material-1 hover:shadow-material-2 transition-all">
                <div class="w-16 h-16 mx-auto mb-4 rounded-full flex items-center justify-center" style="background: #d4af37;">
                    <svg class="w-8 h-8" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
                </div>
                <h3 class="text-xl font-bold mb-2" style="color: #1e3a5f;">Diakonia</h3>
                <p class="text-gray-600">Pelayanan kasih kepada yang membutuhkan</p>
            </div>
            <div class="bg-white rounded-2xl p-6 text-center shadow-material-1 hover:shadow-material-2 transition-all">
                <div class="w-16 h-16 mx-auto mb-4 rounded-full flex items-center justify-center" style="background: #d4af37;">
                    <svg class="w-8 h-8" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/></svg>
                </div>
                <h3 class="text-xl font-bold mb-2" style="color: #1e3a5f;">Pembangunan</h3>
                <p class="text-gray-600">Dana pembangunan gedung gereja</p>
            </div>
        </div>
    </div>
</section>

<!-- Konfirmasi Donasi -->
<section class="py-12 bg-slate-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-2xl mx-auto rounded-2xl p-8 shadow-material-2 bg-white">
            <div class="text-center mb-8">
                <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-3" style="background: rgba(30,58,95,0.1); color: #1e3a5f;">
                    Konfirmasi Transfer
                </span>
                <h2 class="text-2xl font-bold" style="color: #1e3a5f;">Konfirmasi Donasi</h2>
            </div>
            <form action="<?php echo e(route('donasi.konfirmasi')); ?>" method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block font-semibold mb-2" style="color: #1e3a5f;">Nama Lengkap *</label>
                        <input type="text" name="nama" required class="w-full px-4 py-3 rounded-xl text-gray-800 border-2 border-gray-200 focus:outline-none focus:border-blue-400" style="background: #ffffff;">
                    </div>
                    <div>
                        <label class="block font-semibold mb-2" style="color: #1e3a5f;">Nomor Telepon *</label>
                        <input type="tel" name="telepon" required class="w-full px-4 py-3 rounded-xl text-gray-800 border-2 border-gray-200 focus:outline-none focus:border-blue-400" style="background: #ffffff;">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block font-semibold mb-2" style="color: #1e3a5f;">Jumlah Donasi *</label>
                        <input type="number" name="jumlah" required class="w-full px-4 py-3 rounded-xl text-gray-800 border-2 border-gray-200 focus:outline-none focus:border-blue-400" style="background: #ffffff;" placeholder="Rp">
                    </div>
                    <div>
                        <label class="block font-semibold mb-2" style="color: #1e3a5f;">Tujuan Donasi *</label>
                        <select name="tujuan" required class="w-full px-4 py-3 rounded-xl text-gray-800 border-2 border-gray-200 focus:outline-none focus:border-blue-400" style="background: #ffffff;">
                            <option value="persembahan">Persembahan</option>
                            <option value="diakonia">Diakonia</option>
                            <option value="pembangunan">Pembangunan</option>
                        </select>
                    </div>
                </div>
                <div>
                    <label class="block font-semibold mb-2" style="color: #1e3a5f;">Tanggal Transfer *</label>
                    <input type="date" name="tanggal_transfer" required class="w-full px-4 py-3 rounded-xl text-gray-800 border-2 border-gray-200 focus:outline-none focus:border-blue-400" style="background: #ffffff;">
                </div>
                <button type="submit" class="w-full px-8 py-4 rounded-xl font-bold text-lg transition-all shadow-material-1 hover:shadow-material-2" style="background: #1e3a5f; color: #ffffff;">
                    Konfirmasi Donasi
                </button>
            </form>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/donasi.blade.php ENDPATH**/ ?>