<?php $__env->startSection('title', 'Manajemen Donasi'); ?>
<?php $__env->startSection('page-title', 'Manajemen Donasi'); ?>

<?php $__env->startSection('content'); ?>
<!-- Summary Cards -->
<div class="grid grid-cols-1 md:grid-cols-2 gap-5 lg:gap-6 mb-6">
    <!-- Total Donasi Dikonfirmasi -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-emerald-500 rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Total Donasi Dikonfirmasi</p>
                <p class="text-2xl font-bold text-emerald-600">Rp <?php echo e(number_format($totalDonasi, 0, ',', '.')); ?></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-emerald-100 to-emerald-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Donasi yang sudah diverifikasi</span>
        </div>
    </div>
    
    <!-- Menunggu Konfirmasi -->
    <div class="bg-white rounded-2xl shadow-admin-md hover:shadow-admin-lg transition-shadow duration-300 p-6 border border-slate-100 relative overflow-hidden">
        <div class="absolute top-0 left-0 w-1.5 h-full bg-amber-500 rounded-l-2xl"></div>
        <div class="flex items-center justify-between">
            <div class="pl-2">
                <p class="text-slate-500 text-[15px] font-medium mb-1">Menunggu Konfirmasi</p>
                <p class="text-2xl font-bold text-amber-600"><?php echo e($totalPending); ?> <span class="text-base font-medium">donasi</span></p>
            </div>
            <div class="w-14 h-14 bg-gradient-to-br from-amber-100 to-amber-50 rounded-2xl flex items-center justify-center">
                <svg class="w-7 h-7 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
            </div>
        </div>
        <div class="mt-4 pt-4 border-t border-slate-100">
            <span class="text-sm text-slate-500">Perlu ditinjau dan dikonfirmasi</span>
        </div>
    </div>
</div>

<!-- Main Card: Daftar Donasi -->
<div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 p-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-6">
        <div class="flex items-center gap-2">
            <span class="w-1.5 h-7 bg-[#d4af37] rounded-full"></span>
            <h2 class="text-xl font-bold text-[#1e3a5f]">Daftar Donasi</h2>
        </div>
        <a href="<?php echo e(route('admin.donasi.create')); ?>" class="inline-flex items-center justify-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-bold text-[15px] hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah Donasi
        </a>
    </div>

    <?php if($donasiList->total() > 0): ?>
    <div class="overflow-x-auto rounded-xl border border-slate-200">
        <table class="w-full">
            <thead>
                <tr class="bg-slate-50">
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Nama Donatur</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Telepon</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Tujuan</th>
                    <th class="px-5 py-4 text-right text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Jumlah</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Tanggal</th>
                    <th class="px-5 py-4 text-left text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Status</th>
                    <th class="px-5 py-4 text-center text-[13px] font-semibold text-slate-600 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-slate-100">
                <?php $__currentLoopData = $donasiList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $donasi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-slate-50/50 transition-colors duration-150">
                    <td class="px-5 py-4">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-[#1e3a5f] to-[#2d5a8a] flex items-center justify-center text-white font-bold text-sm">
                                <?php echo e(strtoupper(substr($donasi->nama, 0, 1))); ?>

                            </div>
                            <span class="font-semibold text-slate-800 text-[15px]"><?php echo e($donasi->nama); ?></span>
                        </div>
                    </td>
                    <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($donasi->telepon); ?></td>
                    <td class="px-5 py-4">
                        <span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold 
                            <?php echo e($donasi->tujuan == 'persembahan' ? 'bg-blue-100 text-blue-700' : 
                               ($donasi->tujuan == 'diakonia' ? 'bg-pink-100 text-pink-700' : 'bg-orange-100 text-orange-700')); ?>">
                            <?php echo e(ucfirst($donasi->tujuan)); ?>

                        </span>
                    </td>
                    <td class="px-5 py-4 text-right">
                        <span class="font-bold text-emerald-600 text-[15px]">Rp <?php echo e(number_format($donasi->jumlah, 0, ',', '.')); ?></span>
                    </td>
                    <td class="px-5 py-4 text-slate-600 text-[15px]"><?php echo e($donasi->tanggal_transfer->translatedFormat('d M Y')); ?></td>
                    <td class="px-5 py-4">
                        <form action="<?php echo e(route('admin.donasi.status', $donasi->id)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <select name="status" onchange="this.form.submit()" class="px-3 py-2 rounded-xl text-xs font-semibold border-0 cursor-pointer focus:ring-2 focus:ring-[#1e3a5f]/20 transition-all duration-200
                                <?php echo e($donasi->status == 'dikonfirmasi' ? 'bg-emerald-100 text-emerald-700' : 
                                   ($donasi->status == 'pending' ? 'bg-amber-100 text-amber-700' : 'bg-rose-100 text-rose-700')); ?>">
                                <option value="pending" <?php echo e($donasi->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="dikonfirmasi" <?php echo e($donasi->status == 'dikonfirmasi' ? 'selected' : ''); ?>>Dikonfirmasi</option>
                                <option value="ditolak" <?php echo e($donasi->status == 'ditolak' ? 'selected' : ''); ?>>Ditolak</option>
                            </select>
                        </form>
                    </td>
                    <td class="px-5 py-4">
                        <div class="flex items-center justify-center gap-2">
                            <a href="<?php echo e(route('admin.donasi.edit', $donasi->id)); ?>" class="p-2.5 text-[#1e3a5f] hover:bg-blue-50 rounded-xl transition-all duration-200" title="Edit">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/></svg>
                            </a>
                            <form action="<?php echo e(route('admin.donasi.destroy', $donasi->id)); ?>" method="POST" onsubmit="return confirm('Yakin ingin menghapus donasi ini?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="p-2.5 text-rose-600 hover:bg-rose-50 rounded-xl transition-all duration-200" title="Hapus">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    
    <?php echo e($donasiList->links('components.pagination')); ?>

    <?php else: ?>
    <div class="text-center py-16">
        <div class="w-20 h-20 rounded-2xl bg-slate-100 flex items-center justify-center mx-auto mb-5">
            <svg class="w-10 h-10 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/></svg>
        </div>
        <p class="text-slate-500 text-lg font-medium mb-2">Belum ada data donasi</p>
        <p class="text-slate-400 text-[15px] mb-6">Mulai tambahkan donasi pertama</p>
        <a href="<?php echo e(route('admin.donasi.create')); ?>" class="inline-flex items-center gap-2 px-6 py-3 bg-[#1e3a5f] text-white rounded-xl font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/></svg>
            Tambah Donasi Pertama
        </a>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/donasi/index.blade.php ENDPATH**/ ?>