<?php $__env->startSection('title', 'Detail Pesan'); ?>
<?php $__env->startSection('page-title', 'Detail Pesan'); ?>

<?php $__env->startSection('content'); ?>
<!-- Back Button -->
<div class="mb-6">
    <a href="<?php echo e(route('admin.pesan.index')); ?>" class="inline-flex items-center gap-2 px-4 py-2 text-slate-600 hover:text-[#1e3a5f] font-semibold rounded-xl hover:bg-slate-100 transition-all duration-200">
        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
        Kembali ke Daftar Pesan
    </a>
</div>

<!-- Pesan Detail -->
<div class="bg-white rounded-2xl shadow-admin-md border border-slate-100 overflow-hidden">
    <!-- Header -->
    <div class="bg-gradient-to-r from-[#1e3a5f] to-[#2d5a8a] p-6">
        <div class="flex items-start justify-between">
            <div class="flex items-start gap-4">
                <div class="w-14 h-14 rounded-xl bg-white/20 flex items-center justify-center flex-shrink-0">
                    <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                </div>
                <div>
                    <h2 class="text-xl font-bold text-white mb-1"><?php echo e($pesan->subjek); ?></h2>
                    <p class="text-white/70 text-sm">Dikirim pada <?php echo e($pesan->created_at->format('d F Y, H:i')); ?> WIB</p>
                </div>
            </div>
            <span class="inline-flex items-center gap-1.5 px-3 py-1.5 rounded-full text-xs font-semibold <?php echo e($pesan->dibaca ? 'bg-emerald-100 text-emerald-700' : 'bg-amber-100 text-amber-700'); ?>">
                <span class="w-1.5 h-1.5 rounded-full <?php echo e($pesan->dibaca ? 'bg-emerald-500' : 'bg-amber-500'); ?>"></span>
                <?php echo e($pesan->dibaca ? 'Sudah Dibaca' : 'Belum Dibaca'); ?>

            </span>
        </div>
    </div>
    
    <!-- Content -->
    <div class="p-6">
        <!-- Sender Info -->
        <div class="bg-slate-50 rounded-xl p-5 mb-6">
            <h3 class="text-sm font-semibold text-slate-500 uppercase tracking-wider mb-4">Informasi Pengirim</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <p class="text-sm text-slate-500 mb-1">Nama</p>
                    <p class="font-semibold text-[#1e3a5f] text-lg"><?php echo e($pesan->nama); ?></p>
                </div>
                <div>
                    <p class="text-sm text-slate-500 mb-1">Email</p>
                    <a href="mailto:<?php echo e($pesan->email); ?>" class="font-semibold text-[#1e3a5f] text-lg hover:text-[#d4af37] transition-colors"><?php echo e($pesan->email); ?></a>
                </div>
            </div>
        </div>
        
        <!-- Message Content -->
        <div class="mb-6">
            <h3 class="text-sm font-semibold text-slate-500 uppercase tracking-wider mb-4">Isi Pesan</h3>
            <div class="bg-slate-50 rounded-xl p-5">
                <p class="text-slate-700 text-[15px] leading-relaxed whitespace-pre-wrap"><?php echo e($pesan->pesan); ?></p>
            </div>
        </div>
        
        <!-- Read Info -->
        <?php if($pesan->dibaca && $pesan->dibaca_at): ?>
        <div class="text-sm text-slate-500 mb-6">
            <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
            Dibaca pada <?php echo e($pesan->dibaca_at->format('d F Y, H:i')); ?> WIB
        </div>
        <?php endif; ?>
        
        <!-- Actions -->
        <div class="flex flex-wrap items-center gap-3 pt-6 border-t border-slate-200">
            <a href="mailto:<?php echo e($pesan->email); ?>?subject=Re: <?php echo e($pesan->subjek); ?>" class="inline-flex items-center gap-2 px-5 py-2.5 bg-[#1e3a5f] text-white rounded-xl text-sm font-semibold hover:bg-[#2d5a8a] transition-all duration-200 shadow-admin-sm hover:shadow-admin-md">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/></svg>
                Balas via Email
            </a>
            
            <form action="<?php echo e(route('admin.pesan.toggle', $pesan->id)); ?>" method="POST" class="inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <button type="submit" class="inline-flex items-center gap-2 px-5 py-2.5 <?php echo e($pesan->dibaca ? 'bg-amber-100 text-amber-700 hover:bg-amber-200' : 'bg-emerald-100 text-emerald-700 hover:bg-emerald-200'); ?> rounded-xl text-sm font-semibold transition-all duration-200">
                    <?php if($pesan->dibaca): ?>
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    Tandai Belum Dibaca
                    <?php else: ?>
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                    Tandai Sudah Dibaca
                    <?php endif; ?>
                </button>
            </form>
            
            <form action="<?php echo e(route('admin.pesan.destroy', $pesan->id)); ?>" method="POST" class="inline ml-auto" onsubmit="return confirm('Yakin ingin menghapus pesan ini?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="inline-flex items-center gap-2 px-5 py-2.5 bg-red-100 text-red-700 rounded-xl text-sm font-semibold hover:bg-red-200 transition-all duration-200">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/></svg>
                    Hapus Pesan
                </button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/pesan/show.blade.php ENDPATH**/ ?>