<?php $__env->startSection('title', $berita->judul . ' - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Breadcrumb -->
<section class="relative py-12 md:py-16 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    
    <div class="relative max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Breadcrumb -->
        <nav class="flex items-center gap-2 text-sm mb-6">
            <a href="<?php echo e(route('beranda')); ?>" class="text-white/70 hover:text-white transition-colors">Beranda</a>
            <svg class="w-4 h-4 text-white/50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
            <a href="<?php echo e(route('berita.index')); ?>" class="text-white/70 hover:text-white transition-colors">Berita</a>
            <svg class="w-4 h-4 text-white/50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
            <span class="text-white/90 truncate max-w-[200px]"><?php echo e($berita->judul); ?></span>
        </nav>
        
        <!-- Meta Info -->
        <div class="flex flex-wrap items-center gap-4 mb-4">
            <span class="px-3 py-1 rounded-full text-sm font-medium" style="background: rgba(212,175,55,0.2); color: #d4af37;">
                <?php echo e($berita->tanggal_publikasi->translatedFormat('d F Y')); ?>

            </span>
            <?php if($berita->author): ?>
            <span class="text-white/70 text-sm">
                Oleh: <?php echo e($berita->author->name); ?>

            </span>
            <?php endif; ?>
        </div>
        
        <!-- Title -->
        <h1 class="text-2xl md:text-3xl lg:text-4xl font-bold text-white leading-tight">
            <?php echo e($berita->judul); ?>

        </h1>
    </div>
</section>

<!-- Article Content -->
<article class="py-12 bg-white">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <!-- Featured Image -->
        <?php if($berita->gambar): ?>
        <div class="mb-8 -mt-8 relative">
            <img src="<?php echo e(asset('images/' . $berita->gambar)); ?>" alt="<?php echo e($berita->judul); ?>" class="w-full h-auto rounded-2xl shadow-material-2">
        </div>
        <?php endif; ?>
        
        <!-- Author & Date Info -->
        <div class="flex flex-wrap items-center gap-6 mb-8 pb-6 border-b border-gray-200">
            <?php if($berita->author): ?>
            <div class="flex items-center gap-3">
                <div class="w-12 h-12 rounded-full flex items-center justify-center text-white font-bold text-lg" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                    <?php echo e(strtoupper(substr($berita->author->name, 0, 1))); ?>

                </div>
                <div>
                    <p class="font-semibold text-gray-900"><?php echo e($berita->author->name); ?></p>
                    <p class="text-sm text-gray-500">Penulis</p>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="flex items-center gap-3">
                <div class="w-12 h-12 rounded-full flex items-center justify-center" style="background: rgba(212,175,55,0.15);">
                    <svg class="w-6 h-6" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                </div>
                <div>
                    <p class="font-semibold text-gray-900"><?php echo e($berita->tanggal_publikasi->translatedFormat('d F Y')); ?></p>
                    <p class="text-sm text-gray-500">Tanggal Publikasi</p>
                </div>
            </div>
        </div>
        
        <!-- Article Body -->
        <div class="prose prose-lg max-w-none berita-content">
            <div class="text-gray-700 leading-relaxed">
                <?php echo $berita->isi; ?>

            </div>
        </div>
        
        <style>
            .berita-content {
                font-size: 1.1rem;
                line-height: 1.8;
            }
            .berita-content p {
                margin-bottom: 1.25em;
            }
            .berita-content h2 {
                font-size: 1.5em;
                font-weight: 700;
                color: #1e3a5f;
                margin-top: 1.5em;
                margin-bottom: 0.5em;
            }
            .berita-content h3 {
                font-size: 1.25em;
                font-weight: 700;
                color: #1e3a5f;
                margin-top: 1.25em;
                margin-bottom: 0.5em;
            }
            .berita-content h4 {
                font-size: 1.1em;
                font-weight: 600;
                color: #1e3a5f;
                margin-top: 1em;
                margin-bottom: 0.5em;
            }
            .berita-content a {
                color: #d4af37;
                text-decoration: underline;
            }
            .berita-content a:hover {
                color: #1e3a5f;
            }
            .berita-content ul, .berita-content ol {
                margin: 1em 0;
                padding-left: 1.5em;
            }
            .berita-content li {
                margin-bottom: 0.5em;
            }
            .berita-content blockquote {
                border-left: 4px solid #d4af37;
                padding-left: 1em;
                margin: 1.5em 0;
                color: #64748b;
                font-style: italic;
            }
            .berita-content img {
                max-width: 100%;
                height: auto;
                border-radius: 12px;
                margin: 1.5em 0;
            }
            .berita-content table {
                width: 100%;
                border-collapse: collapse;
                margin: 1.5em 0;
            }
            .berita-content table th,
            .berita-content table td {
                border: 1px solid #e2e8f0;
                padding: 10px 14px;
                text-align: left;
            }
            .berita-content table th {
                background: #f8fafc;
                font-weight: 600;
                color: #1e3a5f;
            }
            .berita-content table tr:hover {
                background: #f8fafc;
            }
            .berita-content strong {
                font-weight: 600;
                color: #1e293b;
            }
            .berita-content em {
                font-style: italic;
            }
        </style>
        
        <!-- Share Buttons -->
        <div class="mt-10 pt-8 border-t border-gray-200">
            <p class="text-sm font-semibold text-gray-600 mb-4">Bagikan berita ini:</p>
            <div class="flex items-center gap-3">
                <a href="https://wa.me/?text=<?php echo e(urlencode($berita->judul . ' - ' . url()->current())); ?>" target="_blank" class="inline-flex items-center gap-2 px-4 py-2 bg-green-500 text-white rounded-lg text-sm font-semibold hover:bg-green-600 transition-colors">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/></svg>
                    WhatsApp
                </a>
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>" target="_blank" class="inline-flex items-center gap-2 px-4 py-2 bg-blue-600 text-white rounded-lg text-sm font-semibold hover:bg-blue-700 transition-colors">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/></svg>
                    Facebook
                </a>
            </div>
        </div>
        
        <!-- Back Link -->
        <div class="mt-8">
            <a href="<?php echo e(route('berita.index')); ?>" class="inline-flex items-center gap-2 text-sm font-semibold transition-colors" style="color: #1e3a5f;">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                </svg>
                Kembali ke Daftar Berita
            </a>
        </div>
    </div>
</article>

<!-- Related News -->
<?php if($beritaLainnya->count() > 0): ?>
<section class="py-12 bg-slate-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center gap-4 mb-8">
            <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                </svg>
            </div>
            <div>
                <h2 class="text-2xl font-bold" style="color: #1e3a5f;">Berita Lainnya</h2>
                <p class="text-gray-500 text-sm">Baca juga berita terbaru lainnya</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
            <?php $__currentLoopData = $beritaLainnya; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="bg-white rounded-2xl shadow-material-1 overflow-hidden hover:shadow-material-3 transition-all duration-300 group">
                <a href="<?php echo e(route('berita.show', $item->slug)); ?>" class="block">
                    <div class="relative h-40 overflow-hidden">
                        <?php if($item->gambar): ?>
                        <img src="<?php echo e(asset('images/' . $item->gambar)); ?>" alt="<?php echo e($item->judul); ?>" class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-500">
                        <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                            <svg class="w-12 h-12 text-white/30" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M19 20H5a2 2 0 01-2-2V6a2 2 0 012-2h10a2 2 0 012 2v1m2 13a2 2 0 01-2-2V7m2 13a2 2 0 002-2V9a2 2 0 00-2-2h-2m-4-3H9M7 16h6M7 8h6v4H7V8z"/>
                            </svg>
                        </div>
                        <?php endif; ?>
                    </div>
                </a>
                <div class="p-5">
                    <span class="text-xs text-gray-500 mb-2 block"><?php echo e($item->tanggal_publikasi->translatedFormat('d M Y')); ?></span>
                    <a href="<?php echo e(route('berita.show', $item->slug)); ?>">
                        <h3 class="font-bold line-clamp-2 group-hover:text-primary transition-colors" style="color: #1e3a5f;"><?php echo e($item->judul); ?></h3>
                    </a>
                </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/berita/show.blade.php ENDPATH**/ ?>