

<?php $__env->startSection('title', isset($jadwal) ? 'Edit Ibadah Khusus' : 'Tambah Ibadah Khusus'); ?>
<?php $__env->startSection('page-title', isset($jadwal) ? 'Edit Ibadah Khusus' : 'Tambah Ibadah Khusus'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form
                action="<?php echo e(isset($jadwal) ? route('admin.ibadah-khusus.update', $jadwal->id) : route('admin.ibadah-khusus.store')); ?>"
                method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <?php if(isset($jadwal)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="md:col-span-2">
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Nama Ibadah / Tema
                            *</label>
                        <input type="text" name="nama" value="<?php echo e($jadwal->nama ?? old('nama')); ?>" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                            placeholder="Contoh: Ibadah Syukur Perayaan Natal">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Kategori</label>
                        <select name="kategori"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                            <option value="">Pilih Kategori</option>
                            <option value="Natal" <?php echo e((isset($jadwal) && $jadwal->kategori == 'Natal') ? 'selected' : ''); ?>>
                                Natal</option>
                            <option value="Paskah" <?php echo e((isset($jadwal) && $jadwal->kategori == 'Paskah') ? 'selected' : ''); ?>>
                                Paskah</option>
                            <option value="Perjamuan Kudus" <?php echo e((isset($jadwal) && $jadwal->kategori == 'Perjamuan Kudus') ? 'selected' : ''); ?>>Perjamuan Kudus</option>
                            <option value="Pernikahan" <?php echo e((isset($jadwal) && $jadwal->kategori == 'Pernikahan') ? 'selected' : ''); ?>>Pernikahan</option>
                            <option value="Dukacita" <?php echo e((isset($jadwal) && $jadwal->kategori == 'Dukacita') ? 'selected' : ''); ?>>Dukacita</option>
                            <option value="Lainnya" <?php echo e((isset($jadwal) && $jadwal->kategori == 'Lainnya') ? 'selected' : ''); ?>>Lainnya</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Tanggal *</label>
                        <input type="date" name="tanggal"
                            value="<?php echo e(isset($jadwal) ? $jadwal->tanggal->format('Y-m-d') : old('tanggal')); ?>" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Waktu *</label>
                        <input type="time" name="waktu" value="<?php echo e($jadwal->waktu ?? old('waktu')); ?>" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>

                    <div>
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Tempat *</label>
                        <input type="text" name="tempat" value="<?php echo e($jadwal->tempat ?? old('tempat')); ?>" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                            placeholder="Contoh: Gedung Gereja">
                    </div>

                    <div class="md:col-span-2">
                        <label class="block text-gray-700 font-semibold mb-2" style="color: #1e3a5f;">Pelayan Firman</label>
                        <input type="text" name="pelayan" value="<?php echo e($jadwal->pelayan ?? old('pelayan')); ?>"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                            placeholder="Nama Pendeta / Pengkhotbah">
                    </div>

                    <!-- <div class="flex items-center space-x-6 pt-2">
                                <label class="inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="online" value="1" <?php echo e((isset($jadwal) && $jadwal->online) ? 'checked' : ''); ?> class="hidden peer">
                                    <div
                                        class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-blue-600 relative">
                                    </div>
                                    <span class="ml-3 text-sm font-medium text-gray-700">Tersedia Online (Live Streaming)</span>
                                </label>

                                <label class="inline-flex items-center cursor-pointer">
                                    <input type="checkbox" name="aktif" value="1" <?php echo e((!isset($jadwal) || $jadwal->aktif) ? 'checked' : ''); ?> class="hidden peer">
                                    <div
                                        class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-green-600 relative">
                                    </div>
                                    <span class="ml-3 text-sm font-medium text-gray-700">Aktif</span>
                                </label>
                            </div> -->
                </div>

                <div class="flex items-center gap-4 pt-6 ">
                    <button type="submit"
                        class="px-8 py-3 bg-gereja-biru text-white rounded-xl font-bold hover:bg-gereja-biru-light transition-all shadow-md">
                        <?php echo e(isset($jadwal) ? 'Update' : 'Simpan'); ?>

                    </button>
                    <a href="<?php echo e(route('admin.ibadah-khusus.index')); ?>"
                        class="px-8 py-3 bg-gray-200 text-gray-700 rounded-xl font-bold hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/ibadah-khusus/form.blade.php ENDPATH**/ ?>