<?php $__env->startSection('title', isset($event) ? 'Edit Event' : 'Tambah Event'); ?>
<?php $__env->startSection('page-title', isset($event) ? 'Edit Event Kalender' : 'Tambah Event Kalender'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-3xl">
        <div class="bg-white rounded-xl shadow-md p-6">
            <form action="<?php echo e(isset($event) ? route('admin.kalender.update', $event->id) : route('admin.kalender.store')); ?>"
                method="POST" class="space-y-6">
                <?php echo csrf_field(); ?>
                <?php if(isset($event)): ?>
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Nama Event *</label>
                    <input type="text" name="nama" value="<?php echo e($event->nama ?? old('nama')); ?>" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Ibadah Natal">
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tanggal *</label>
                        <input type="date" name="tanggal"
                            value="<?php echo e(isset($event) ? $event->tanggal->format('Y-m-d') : old('tanggal')); ?>" required
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                    <div>
                        <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Waktu</label>
                        <input type="time" name="waktu"
                            value="<?php echo e(isset($event) ? substr($event->waktu, 0, 5) : old('waktu')); ?>"
                            class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                    </div>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tipe Event *</label>
                    <select name="tipe" required
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400">
                        <option value="">Pilih Tipe</option>
                        <option value="ibadah" <?php echo e((isset($event) && $event->tipe == 'ibadah') ? 'selected' : ''); ?>>Ibadah
                        </option>
                        <option value="khusus" <?php echo e((isset($event) && $event->tipe == 'khusus') ? 'selected' : ''); ?>>Khusus
                        </option>
                        <option value="kegiatan" <?php echo e((isset($event) && $event->tipe == 'kegiatan') ? 'selected' : ''); ?>>
                            Kegiatan</option>
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Tempat</label>
                    <input type="text" name="tempat" value="<?php echo e($event->tempat ?? old('tempat')); ?>"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Contoh: Gedung Gereja Utama">
                </div>

                <div>
                    <label class="block text-sm font-semibold mb-2" style="color: #1e3a5f;">Deskripsi</label>
                    <textarea name="deskripsi" rows="3"
                        class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:border-blue-400"
                        placeholder="Deskripsi event"><?php echo e($event->deskripsi ?? old('deskripsi')); ?></textarea>
                </div>

                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="aktif" value="1" <?php echo e((isset($event) && $event->aktif) ? 'checked' : (!isset($event) ? 'checked' : '')); ?> class="w-5 h-5 mr-3 rounded border-gray-300">
                        <span class="text-sm font-semibold" style="color: #1e3a5f;">Event Aktif</span>
                    </label>
                </div>

                <div class="flex items-center gap-4 pt-4">
                    <button type="submit"
                        class="px-6 py-3 rounded-xl font-semibold transition-all shadow-material-1 hover:shadow-material-2"
                        style="background: #1e3a5f; color: #ffffff;">
                        <?php echo e(isset($event) ? 'Update Event' : 'Simpan Event'); ?>

                    </button>
                    <a href="<?php echo e(route('admin.kalender.index')); ?>"
                        class="px-6 py-3 rounded-xl font-semibold bg-gray-200 text-gray-700 hover:bg-gray-300 transition-all">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/kalender/form.blade.php ENDPATH**/ ?>