<?php $__env->startSection('title', 'Profil Gereja - Gereja Jemaat Buntu Ambaang'); ?>

<?php $__env->startSection('content'); ?>
<!-- Header with Material Design -->
<section class="relative py-16 md:py-20 overflow-hidden" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
    <div class="absolute top-0 right-0 w-64 h-64 rounded-full opacity-10" style="background: #d4af37; filter: blur(60px);"></div>
    <div class="absolute bottom-0 left-0 w-48 h-48 rounded-full opacity-10" style="background: #ffffff; filter: blur(40px);"></div>
    
    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <span class="inline-block px-4 py-1.5 rounded-full text-sm font-medium mb-4" style="background: rgba(212,175,55,0.2); color: #d4af37;">
            Tentang Kami
        </span>
        <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold mb-4" style="color: #ffffff; text-shadow: 0 2px 4px rgba(0,0,0,0.1);">
            Profil Gereja
        </h1>
        <p class="text-lg md:text-xl max-w-2xl mx-auto" style="color: rgba(255,255,255,0.85);">
            <?php echo e($profil['nama_gereja']); ?>

        </p>
    </div>
</section>

<!-- Info Gereja -->
<section class="py-12 bg-white">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-slate-50 rounded-2xl p-8 shadow-material-1">
            <div class="flex flex-col md:flex-row gap-8 items-center">
                <div class="w-32 h-32 rounded-2xl flex items-center justify-center" style="background: linear-gradient(135deg, #1e3a5f 0%, #2d5a8a 100%);">
                    <svg class="w-16 h-16 text-white" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M12 2L2 12h3v8h6v-6h2v6h6v-8h3L12 2z"/>
                    </svg>
                </div>
                <div class="flex-1 text-center md:text-left">
                    <h2 class="text-2xl font-bold mb-2" style="color: #1e3a5f;"><?php echo e($profil['nama_gereja']); ?></h2>
                    <p class="text-gray-600 mb-4">Berdiri sejak tahun <?php echo e($profil['tahun_berdiri']); ?></p>
                    <div class="flex flex-wrap gap-4 justify-center md:justify-start text-sm text-gray-600">
                        <span class="flex items-center gap-2">
                            <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/></svg>
                            <?php echo e($profil['alamat']); ?>

                        </span>
                    </div>
                    <div class="flex flex-wrap gap-4 justify-center md:justify-start text-sm text-gray-600 mt-2">
                        <span class="flex items-center gap-2">
                            <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                            <?php echo e($profil['telepon']); ?>

                        </span>
                        <span class="flex items-center gap-2">
                            <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                            <?php echo e($profil['email']); ?>

                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Visi & Misi -->
<section class="py-12 bg-slate-50">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Visi -->
            <div class="bg-white rounded-2xl p-8 shadow-material-1">
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: rgba(212,175,55,0.2);">
                        <svg class="w-6 h-6" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                    </div>
                    <h3 class="text-xl font-bold" style="color: #1e3a5f;">Visi</h3>
                </div>
                <p class="text-gray-700 leading-relaxed text-lg italic">
                    "<?php echo e($profil['visi']); ?>"
                </p>
            </div>

            <!-- Misi -->
            <div class="bg-white rounded-2xl p-8 shadow-material-1">
                <div class="flex items-center gap-3 mb-6">
                    <div class="w-12 h-12 rounded-xl flex items-center justify-center" style="background: rgba(30,58,95,0.1);">
                        <svg class="w-6 h-6" style="color: #1e3a5f;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/></svg>
                    </div>
                    <h3 class="text-xl font-bold" style="color: #1e3a5f;">Misi</h3>
                </div>
                <ol class="space-y-3">
                    <?php $__currentLoopData = $profil['misi']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $misi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="flex gap-3">
                        <span class="flex-shrink-0 w-6 h-6 rounded-full flex items-center justify-center text-sm font-bold" style="background: #d4af37; color: #1e3a5f;"><?php echo e($index + 1); ?></span>
                        <span class="text-gray-700"><?php echo e($misi); ?></span>
                    </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Pendeta -->
<section class="py-12 bg-white">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold text-center mb-8" style="color: #1e3a5f;">Pendeta Jemaat</h2>
        
        <div class="max-w-md mx-auto bg-slate-50 rounded-2xl p-8 shadow-material-1 text-center">
            <div class="mx-auto mb-6">
                <?php if (isset($component)) { $__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.profile-photo','data' => ['foto' => $pendeta['foto'],'nama' => $pendeta['nama'],'size' => 'xl','class' => 'mx-auto shadow-material-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('profile-photo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['foto' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pendeta['foto']),'nama' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pendeta['nama']),'size' => 'xl','class' => 'mx-auto shadow-material-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f)): ?>
<?php $attributes = $__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f; ?>
<?php unset($__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f)): ?>
<?php $component = $__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f; ?>
<?php unset($__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f); ?>
<?php endif; ?>
            </div>
            <h3 class="text-xl font-bold mb-1" style="color: #1e3a5f;"><?php echo e($pendeta['nama']); ?></h3>
            <p class="font-medium mb-4" style="color: #d4af37;"><?php echo e($pendeta['jabatan']); ?></p>
            <p class="text-sm text-gray-600 mb-4">Melayani sejak <?php echo e($pendeta['mulai_melayani']); ?></p>
            <div class="flex flex-col gap-2 text-sm text-gray-600">
                <span class="flex items-center justify-center gap-2">
                    <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/></svg>
                    <?php echo e($pendeta['telepon']); ?>

                </span>
                <span class="flex items-center justify-center gap-2">
                    <svg class="w-4 h-4" style="color: #d4af37;" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/></svg>
                    <?php echo e($pendeta['email']); ?>

                </span>
            </div>
        </div>
    </div>
</section>

<!-- Majelis -->
<section class="py-12 bg-slate-50">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-2xl font-bold text-center mb-8" style="color: #1e3a5f;">Majelis Gereja</h2>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php $__currentLoopData = $majelis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $anggota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-2xl p-6 shadow-material-1 text-center hover:shadow-material-2 transition-all">
                <div class="mx-auto mb-4">
                    <?php if (isset($component)) { $__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.profile-photo','data' => ['foto' => $anggota['foto'],'nama' => $anggota['nama'],'size' => 'md','class' => 'mx-auto']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('profile-photo'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['foto' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($anggota['foto']),'nama' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($anggota['nama']),'size' => 'md','class' => 'mx-auto']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f)): ?>
<?php $attributes = $__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f; ?>
<?php unset($__attributesOriginal87dd64f4446cac60bd3f32c693fc1f3f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f)): ?>
<?php $component = $__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f; ?>
<?php unset($__componentOriginal87dd64f4446cac60bd3f32c693fc1f3f); ?>
<?php endif; ?>
                </div>
                <h4 class="font-bold mb-1" style="color: #1e3a5f;"><?php echo e($anggota['nama']); ?></h4>
                <p class="text-sm font-medium mb-1" style="color: #d4af37;"><?php echo e($anggota['jabatan']); ?></p>
                <p class="text-xs text-gray-500"><?php echo e($anggota['bidang']); ?></p>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.public', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/public/profil.blade.php ENDPATH**/ ?>