<?php $__env->startSection('title', 'Manajemen Pengguna & Jemaat'); ?>
<?php $__env->startSection('page-title', 'Manajemen Pengguna & Jemaat'); ?>

<?php $__env->startSection('content'); ?>
<!-- Pengguna Admin -->
<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <h2 class="text-xl font-bold text-gereja-biru mb-4 md:mb-0">Daftar Pengguna Admin</h2>
        <a href="<?php echo e(route('admin.user.create')); ?>" class="inline-flex items-center px-6 py-3 bg-gereja-biru text-white rounded-lg font-bold hover:bg-gereja-biru-light transition">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6" />
            </svg>
            Tambah Pengguna
        </a>
    </div>

    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-3 text-left text-gray-600">Nama</th>
                    <th class="px-4 py-3 text-left text-gray-600">Email</th>
                    <th class="px-4 py-3 text-left text-gray-600">Role</th>
                    <th class="px-4 py-3 text-left text-gray-600">Status</th>
                    <th class="px-4 py-3 text-left text-gray-600">Aksi</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-100">
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="hover:bg-gray-50">
                    <td class="px-4 py-4">
                        <div class="flex items-center">
                            <div class="w-10 h-10 bg-gereja-biru rounded-full flex items-center justify-center mr-3">
                                <span class="text-white font-bold"><?php echo e(substr($user->name, 0, 1)); ?></span>
                            </div>
                            <span class="font-semibold"><?php echo e($user->name); ?></span>
                        </div>
                    </td>
                    <td class="px-4 py-4"><?php echo e($user->email); ?></td>
                    <td class="px-4 py-4">
                        <span class="px-3 py-1 rounded-full text-xs font-semibold <?php echo e($user->role == 'pendeta' ? 'bg-purple-100 text-purple-700' : 'bg-blue-100 text-blue-700'); ?>">
                            <?php echo e(ucfirst($user->role ?? 'admin')); ?>

                        </span>
                    </td>
                    <td class="px-4 py-4">
                        <span class="px-3 py-1 rounded-full text-xs font-semibold <?php echo e($user->is_active ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'); ?>">
                            <?php echo e($user->is_active ? 'Aktif' : 'Nonaktif'); ?>

                        </span>
                    </td>
                    <td class="px-4 py-4">
                        <div class="flex items-center space-x-2">
                            <a href="<?php echo e(route('admin.user.edit', $user->id)); ?>" class="p-2 text-blue-600 hover:bg-blue-100 rounded-lg" title="Edit">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
                                </svg>
                            </a>
                            <form action="<?php echo e(route('admin.user.reset', $user->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="p-2 text-yellow-600 hover:bg-yellow-100 rounded-lg" title="Reset Password">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 7a2 2 0 012 2m4 0a6 6 0 01-7.743 5.743L11 17H9v2H7v2H4a1 1 0 01-1-1v-2.586a1 1 0 01.293-.707l5.964-5.964A6 6 0 1121 9z" />
                                    </svg>
                                </button>
                            </form>
                            <?php if($user->id != auth()->id()): ?>
                            <form action="<?php echo e(route('admin.user.destroy', $user->id)); ?>" method="POST" onsubmit="return confirm('Yakin ingin menghapus?')">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="p-2 text-red-600 hover:bg-red-100 rounded-lg" title="Hapus">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                    </svg>
                                </button>
                            </form>
                            <?php endif; ?>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Data Jemaat -->
<div class="bg-white rounded-xl shadow-md p-6">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
            <h2 class="text-xl font-bold text-gereja-biru">Data Jemaat</h2>
            <p class="text-gray-600 text-sm mt-1">
                Total Aktif: <strong><?php echo e($totalJemaat); ?></strong> |
                Menunggu Verifikasi: <strong class="text-amber-600"><?php echo e($totalPending); ?></strong>
            </p>
        </div>
        <button onclick="openModal('tambahJemaatModal')" class="inline-flex items-center px-6 py-3 bg-green-600 text-white rounded-lg font-bold hover:bg-green-700 transition mt-4 md:mt-0">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" />
            </svg>
            Tambah Jemaat
        </button>
    </div>

    <!-- Tabs -->
    <div class="border-b border-gray-200 mb-6">
        <nav class="flex space-x-4">
            <button onclick="showJemaatTab('pending')" id="tab-pending" class="jemaat-tab px-4 py-2 font-semibold text-amber-600 border-b-2 border-amber-500">
                Menunggu Verifikasi (<?php echo e($totalPending); ?>)
            </button>
            <button onclick="showJemaatTab('aktif')" id="tab-aktif" class="jemaat-tab px-4 py-2 font-semibold text-gray-500 hover:text-gray-700">
                Aktif (<?php echo e($totalJemaat); ?>)
            </button>
            <button onclick="showJemaatTab('ditolak')" id="tab-ditolak" class="jemaat-tab px-4 py-2 font-semibold text-gray-500 hover:text-gray-700">
                Ditolak (<?php echo e($jemaatDitolak->count()); ?>)
            </button>
        </nav>
    </div>

    <!-- Tab Content: Pending -->
    <div id="content-pending" class="jemaat-content">
        <?php if($jemaatPending->count() > 0): ?>
        <div class="space-y-4">
            <?php $__currentLoopData = $jemaatPending; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-amber-50 border border-amber-200 rounded-xl p-5">
                <div class="flex flex-col lg:flex-row lg:items-start lg:justify-between gap-4">
                    <div class="flex-grow">
                        <div class="flex items-center gap-3 mb-2">
                            <h3 class="font-bold text-lg text-gray-800"><?php echo e($j->nama); ?></h3>
                            <span class="px-2 py-1 bg-amber-200 text-amber-800 rounded-full text-xs font-semibold"><?php echo e($j->kode); ?></span>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-2 text-sm text-gray-600">
                            <p><span class="font-medium">Jenis Kelamin:</span> <?php echo e($j->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'); ?></p>
                            <p><span class="font-medium">TTL:</span> <?php echo e($j->tempat_lahir); ?>, <?php echo e($j->tanggal_lahir ? $j->tanggal_lahir->format('d M Y') : '-'); ?></p>
                            <p><span class="font-medium">Telepon:</span> <?php echo e($j->telepon); ?></p>
                            <p><span class="font-medium">Email:</span> <?php echo e($j->email ?? '-'); ?></p>
                            <p><span class="font-medium">Status:</span> <?php echo e($j->status_pernikahan); ?></p>
                            <p><span class="font-medium">Pekerjaan:</span> <?php echo e($j->pekerjaan); ?></p>
                        </div>
                        <p class="text-sm text-gray-600 mt-2"><span class="font-medium">Alamat:</span> <?php echo e($j->alamat); ?></p>
                        <p class="text-xs text-gray-400 mt-2">Didaftarkan: <?php echo e($j->created_at->format('d M Y H:i')); ?></p>
                    </div>
                    <div class="flex flex-wrap gap-2">
                        <form action="<?php echo e(route('admin.jemaat.status', $j->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <input type="hidden" name="status" value="aktif">
                            <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg font-semibold text-sm hover:bg-green-700 transition">
                                Terima
                            </button>
                        </form>
                        <form action="<?php echo e(route('admin.jemaat.status', $j->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <input type="hidden" name="status" value="ditolak">
                            <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-lg font-semibold text-sm hover:bg-red-700 transition">
                                Tolak
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php else: ?>
        <div class="text-center py-8 text-gray-500">
            <svg class="w-12 h-12 mx-auto mb-3 text-gray-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
            </svg>
            <p>Tidak ada pendaftaran yang menunggu verifikasi</p>
        </div>
        <?php endif; ?>
    </div>

    <!-- Tab Content: Aktif -->
    <div id="content-aktif" class="jemaat-content hidden">
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-gray-600">Kode</th>
                        <th class="px-4 py-3 text-left text-gray-600">Nama</th>
                        <th class="px-4 py-3 text-left text-gray-600">Telepon</th>
                        <th class="px-4 py-3 text-left text-gray-600">Email</th>
                        <th class="px-4 py-3 text-left text-gray-600">Alamat</th>
                        <th class="px-4 py-3 text-left text-gray-600">Aksi</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100">
                    <?php $__empty_1 = true; $__currentLoopData = $jemaatAktif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-4 text-sm font-mono text-gray-500"><?php echo e($j->kode ?? '-'); ?></td>
                        <td class="px-4 py-4 font-semibold"><?php echo e($j->nama); ?></td>
                        <td class="px-4 py-4"><?php echo e($j->telepon); ?></td>
                        <td class="px-4 py-4"><?php echo e($j->email ?? '-'); ?></td>
                        <td class="px-4 py-4 text-sm"><?php echo e(Str::limit($j->alamat, 30)); ?></td>
                        <td class="px-4 py-4">
                            <div class="flex items-center space-x-2">
                                <button onclick="viewJemaat(<?php echo e($j->id); ?>)" class="p-2 text-blue-600 hover:bg-blue-100 rounded-lg" title="Lihat Detail">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                                    </svg>
                                </button>
                                <form action="<?php echo e(route('admin.jemaat.destroy', $j->id)); ?>" method="POST" onsubmit="return confirm('Yakin ingin menghapus jemaat ini?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="p-2 text-red-600 hover:bg-red-100 rounded-lg" title="Hapus">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                        </svg>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-4 py-8 text-center text-gray-500">Belum ada jemaat terdaftar</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php echo e($jemaatAktif->links('components.pagination')); ?>

    </div>

    <!-- Tab Content: Ditolak -->
    <div id="content-ditolak" class="jemaat-content hidden">
        <?php if($jemaatDitolak->count() > 0): ?>
        <div class="space-y-4">
            <?php $__currentLoopData = $jemaatDitolak; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-red-50 border border-red-200 rounded-xl p-5">
                <div class="flex flex-col lg:flex-row lg:items-start lg:justify-between gap-4">
                    <div class="flex-grow">
                        <div class="flex items-center gap-3 mb-2">
                            <h3 class="font-bold text-lg text-gray-800"><?php echo e($j->nama); ?></h3>
                            <span class="px-2 py-1 bg-red-200 text-red-800 rounded-full text-xs font-semibold">Ditolak</span>
                        </div>
                        <p class="text-sm text-gray-600"><span class="font-medium">Telepon:</span> <?php echo e($j->telepon); ?></p>
                        <p class="text-xs text-gray-400 mt-2">Didaftarkan: <?php echo e($j->created_at->format('d M Y H:i')); ?></p>
                    </div>
                    <div class="flex flex-wrap gap-2">
                        <form action="<?php echo e(route('admin.jemaat.status', $j->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                            <input type="hidden" name="status" value="aktif">
                            <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-lg font-semibold text-sm hover:bg-green-700 transition">
                                Terima
                            </button>
                        </form>
                        <form action="<?php echo e(route('admin.jemaat.destroy', $j->id)); ?>" method="POST" onsubmit="return confirm('Hapus permanen?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="px-4 py-2 bg-gray-600 text-white rounded-lg font-semibold text-sm hover:bg-gray-700 transition">
                                Hapus
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <?php else: ?>
        <div class="text-center py-8 text-gray-500">
            <p>Tidak ada data jemaat yang ditolak</p>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal Tambah Jemaat -->
<div id="tambahJemaatModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="fixed inset-0 bg-black opacity-50" onclick="closeModal('tambahJemaatModal')"></div>
        <div class="relative bg-white rounded-xl shadow-lg max-w-2xl w-full max-h-[90vh] overflow-y-auto">
            <div class="p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-bold text-gereja-biru">Tambah Jemaat Baru</h3>
                    <button onclick="closeModal('tambahJemaatModal')" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.jemaat.store')); ?>" method="POST" class="space-y-4">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">Nama Lengkap *</label>
                        <input type="text" name="nama" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Jenis Kelamin *</label>
                            <select name="jenis_kelamin" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                                <option value="">Pilih</option>
                                <option value="L">Laki-laki</option>
                                <option value="P">Perempuan</option>
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Status Pernikahan *</label>
                            <select name="status_pernikahan" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                                <option value="">Pilih</option>
                                <option value="Belum Menikah">Belum Menikah</option>
                                <option value="Menikah">Menikah</option>
                                <option value="Duda">Duda</option>
                                <option value="Janda">Janda</option>
                            </select>
                        </div>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Tempat Lahir *</label>
                            <input type="text" name="tempat_lahir" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Tanggal Lahir *</label>
                            <input type="date" name="tanggal_lahir" required max="<?php echo e(date('Y-m-d')); ?>" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">Alamat Lengkap *</label>
                        <textarea name="alamat" rows="2" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"></textarea>
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Telepon/WhatsApp *</label>
                            <input type="tel" name="telepon" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-semibold text-gray-700 mb-1">Email</label>
                            <input type="email" name="email" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                        </div>
                    </div>
                    <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-1">Pekerjaan *</label>
                        <input type="text" name="pekerjaan" required class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500">
                    </div>
                    <div class="flex justify-end gap-3 pt-4">
                        <button type="button" onclick="closeModal('tambahJemaatModal')" class="px-6 py-2 border border-gray-300 rounded-lg font-semibold text-gray-600 hover:bg-gray-50">
                            Batal
                        </button>
                        <button type="submit" class="px-6 py-2 bg-green-600 text-white rounded-lg font-semibold hover:bg-green-700">
                            Simpan
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Detail Jemaat -->
<div id="detailJemaatModal" class="fixed inset-0 z-50 hidden overflow-y-auto">
    <div class="flex items-center justify-center min-h-screen px-4">
        <div class="fixed inset-0 bg-black opacity-50" onclick="closeModal('detailJemaatModal')"></div>
        <div class="relative bg-white rounded-xl shadow-lg max-w-lg w-full">
            <div class="p-6">
                <div class="flex items-center justify-between mb-6">
                    <h3 class="text-xl font-bold text-gereja-biru">Detail Jemaat</h3>
                    <button onclick="closeModal('detailJemaatModal')" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <div id="detailJemaatContent" class="space-y-3">
                    <!-- Content will be loaded via JS -->
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    function showJemaatTab(tab) {
        document.querySelectorAll('.jemaat-content').forEach(el => el.classList.add('hidden'));
        document.querySelectorAll('.jemaat-tab').forEach(el => {
            el.classList.remove('text-amber-600', 'border-b-2', 'border-amber-500');
            el.classList.add('text-gray-500');
        });

        document.getElementById('content-' + tab).classList.remove('hidden');
        const activeTab = document.getElementById('tab-' + tab);
        activeTab.classList.remove('text-gray-500');
        activeTab.classList.add('text-amber-600', 'border-b-2', 'border-amber-500');
    }

    function openModal(modalId) {
        document.getElementById(modalId).classList.remove('hidden');
        document.body.style.overflow = 'hidden';
    }

    function closeModal(modalId) {
        document.getElementById(modalId).classList.add('hidden');
        document.body.style.overflow = 'auto';
    }

    function viewJemaat(id) {
        fetch(`/admin/jemaat/${id}`)
            .then(response => response.json())
            .then(data => {
                const content = `
                <div class="grid grid-cols-2 gap-4">
                    <div><span class="text-gray-500 text-sm">Kode</span><p class="font-semibold">${data.kode || '-'}</p></div>
                    <div><span class="text-gray-500 text-sm">Nama</span><p class="font-semibold">${data.nama}</p></div>
                    <div><span class="text-gray-500 text-sm">Jenis Kelamin</span><p class="font-semibold">${data.jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'}</p></div>
                    <div><span class="text-gray-500 text-sm">Status Pernikahan</span><p class="font-semibold">${data.status_pernikahan || '-'}</p></div>
                    <div><span class="text-gray-500 text-sm">Tempat Lahir</span><p class="font-semibold">${data.tempat_lahir || '-'}</p></div>
                    <div><span class="text-gray-500 text-sm">Tanggal Lahir</span><p class="font-semibold">${data.tanggal_lahir ? new Date(data.tanggal_lahir).toLocaleDateString('id-ID') : '-'}</p></div>
                    <div><span class="text-gray-500 text-sm">Telepon</span><p class="font-semibold">${data.telepon}</p></div>
                    <div><span class="text-gray-500 text-sm">Email</span><p class="font-semibold">${data.email || '-'}</p></div>
                    <div class="col-span-2"><span class="text-gray-500 text-sm">Pekerjaan</span><p class="font-semibold">${data.pekerjaan || '-'}</p></div>
                    <div class="col-span-2"><span class="text-gray-500 text-sm">Alamat</span><p class="font-semibold">${data.alamat || '-'}</p></div>
                </div>
            `;
                document.getElementById('detailJemaatContent').innerHTML = content;
                openModal('detailJemaatModal');
            });
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH E:\Documents\UKI 2025\MELISA POTTA\PROGRAM\03\gereja-buntu-ambaang\resources\views/admin/user/index.blade.php ENDPATH**/ ?>