/** @type {import('tailwindcss').Config} */
export default {
  content: [
    "./resources/**/*.blade.php",
    "./resources/**/*.js",
    "./resources/**/*.vue",
  ],
  theme: {
    extend: {
      colors: {
        'gereja-biru': '#1e3a5f',
        'gereja-emas': '#d4af37',
        'gereja-biru-light': '#2d5a8a',
        'gereja-biru-dark': '#152a45',
        'gereja-emas-light': '#e6c85a',
        'admin': {
          'primary': '#1e3a5f',
          'primary-light': '#2d5a8a',
          'primary-dark': '#152a45',
          'accent': '#d4af37',
          'accent-light': '#e6c85a',
          'surface': '#ffffff',
          'surface-dim': '#f8fafc',
          'surface-container': '#f1f5f9',
          'on-primary': '#ffffff',
          'on-accent': '#1e3a5f',
          'outline': '#e2e8f0',
        },
      },
      fontFamily: {
        'sans': ['Nunito', 'Inter', 'ui-sans-serif', 'system-ui', 'sans-serif'],
      },
      fontSize: {
        'admin-xs': ['0.8125rem', { lineHeight: '1.25rem' }],
        'admin-sm': ['0.9375rem', { lineHeight: '1.5rem' }],
        'admin-base': ['1.0625rem', { lineHeight: '1.75rem' }],
        'admin-lg': ['1.1875rem', { lineHeight: '1.875rem' }],
        'admin-xl': ['1.375rem', { lineHeight: '2rem' }],
        'admin-2xl': ['1.625rem', { lineHeight: '2.25rem' }],
      },
      borderRadius: {
        'admin': '0.75rem',
        'admin-lg': '1rem',
        'admin-xl': '1.25rem',
        'admin-2xl': '1.5rem',
      },
      boxShadow: {
        'admin-sm': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
        'admin': '0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1)',
        'admin-md': '0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1)',
        'admin-lg': '0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1)',
        'admin-xl': '0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1)',
        'admin-inner': 'inset 0 2px 4px 0 rgb(0 0 0 / 0.05)',
        'admin-glow': '0 0 20px rgb(30 58 95 / 0.15)',
      },
      spacing: {
        'admin-sidebar': '280px',
      },
      transitionTimingFunction: {
        'admin': 'cubic-bezier(0.4, 0, 0.2, 1)',
      },
    },
  },
  plugins: [],
}
