<?php

namespace Tests\Unit;

use Tests\TestCase;
use App\Models\Oig;

class OigNormalizationTest extends TestCase
{
    /** @test */
    public function it_normalizes_legacy_pengurus_data()
    {
        $oig = new Oig();

        // Legacy format (associative array: Jabatan => Nama)
        $legacyData = [
            'Ketua' => 'Bpk. Abraham',
            'Bendahara' => 'Bpk. Yusuf',
        ];

        // Simulate database value (JSON)
        $oig->setRawAttributes([
            'pengurus' => json_encode($legacyData)
        ]);

        $expected = [
            ['nama' => 'Bpk. Abraham', 'jabatan' => 'Ketua'],
            ['nama' => 'Bpk. Yusuf', 'jabatan' => 'Bendahara'],
        ];

        $this->assertEquals($expected, $oig->pengurus);
    }

    /** @test */
    public function it_keeps_new_pengurus_data_format()
    {
        $oig = new Oig();

        // New format (list of objects)
        $newData = [
            ['nama' => 'Bpk. Abraham', 'jabatan' => 'Ketua'],
            ['nama' => 'Bpk. Yusuf', 'jabatan' => 'Bendahara'],
        ];

        // Simulate database value (JSON)
        $oig->setRawAttributes([
            'pengurus' => json_encode($newData)
        ]);

        $this->assertEquals($newData, $oig->pengurus);
    }

    /** @test */
    public function it_returns_empty_array_for_null_pengurus()
    {
        $oig = new Oig();

        $oig->setRawAttributes([
            'pengurus' => null
        ]);

        $this->assertEquals([], $oig->pengurus);
    }
}
